USE Obfuscation;

IF OBJECT_ID( 'teObfuscationTable' ) IS NOT NULL
BEGIN
    RAISERROR( 'This script has already been run', 0, 1 );
    RETURN;
END

CREATE TABLE teObfuscationTable(
    TableID INT NOT NULL CONSTRAINT pkObfuscationTable PRIMARY KEY CLUSTERED,
    DatabaseName VARCHAR(100) NOT NULL,
    TableName VARCHAR(100) NOT NULL,
    AutoGenerate BIT NOT NULL CONSTRAINT dfObfuscationTable_AutoGenerate DEFAULT(1),
    ObfStatement VARCHAR(MAX) 
);

CREATE NONCLUSTERED INDEX xnObfuscationTable_AutoGenerated
ON teObfuscationTable(
    AutoGenerate
) INCLUDE( 
    DatabaseName, 
    TableName 
);